var Service = require('Service');
var User = require('../../dao/user');
var Org = require('../../dao/org');
var util = require('util');
var utils = require('utils');

/**
 * 恢复默认密码
 */
var RecoveryPwd = function() { 
  Service.call(this);
};

util.inherits(RecoveryPwd, Service);

module.exports = RecoveryPwd;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
RecoveryPwd.prototype.process =  function(req, res) {
  if(!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  var userIds = utils.strToIntArray(req.userId);
  if(userIds.length==0) {
    this.onLogicError(2, '请选择要转移的用户！');
    return;
  }
  userIds = userIds.join();

  var self = this;
  req.session.cache.getCurOrg(function(org) {
    var userDao = new User(self);
    userDao.execute('update sys_user set password=\''+org.default_pwd+'\' where org_id='
      +req.session.orgId+' and id in ('+userIds+')', null, function(ret) {
      req.session.cache.set('user', '['+userIds+'].contains(#{id})', 
        {password:org.default_pwd}, true, function(err){
        if(err) {
          self.onLogicError(6, err.message, req, res, cb);
          return;
        }
        self.end(res);
      });
    });
  });
};