var Service = require('Service');
var util = require('util');
var utils = require('utils');
var User = require('../../dao/vuser');
var Dep = require('../../dao/dep');

/**
 * 准备修改用户信息
 */
var PreUpdate = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(PreUpdate, Service);

module.exports = PreUpdate;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
PreUpdate.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的用户编号！');
    return;
  }
  var self = this;
  var dao = new User(this);
  dao.query({
    fields:'id,code,name,loginname,mobile,email,motto,sex,post,dep_id as depId,'+
    'create_group,nickname,tel_short,tel_work,tel_home,tel_other,not_bind_device,'+
    'only_app_center,disable_app_center,disable_taskmsg,disable_address_book,'
    +'disable_work_circle,disable_chpwd,disk_limit,disk_limit_unit,file_size_limit,bind_ca',
    where:'org_id='+req.session.orgId+' and id='+req.id}, 
    function(rows) {
    if(rows.length==0) {
      self.onLogicError(2, '请提供正确的用户编号！');
      return;
    }
    res.user = rows[0];
    if(!res.user.not_bind_device && res.user.not_bind_device!=0) res.user.not_bind_device = 0;
    self.end(res);
  });
};