var Service = require('Service');
var util = require('util');
var utils = require('utils');
var UserPost = require('../../dao/user_post');
var Org = require('../../dao/org');

/**
 * 准备添加用户信息
 */
var PreInsert = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(PreInsert, Service);

module.exports = PreInsert;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
PreInsert.prototype.process =  function(req, res) {
  var self = this;
  var dao = new UserPost(this);
  dao.query({
    fields:'id,code,name',
    where:'org_id='+req.session.orgId}, 
    function(rows) {
    res.postList = rows;
    var daoOrg = new Org(self);
    daoOrg.query({fields:'disable_chpwd',where:'id='+req.session.orgId}, function(rows2) {
      res.org = rows2[0];
      self.end(res);
    });
  });
};