var util = require('util');
var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/user');

var ImportAppoint = function() {
  Service.call(this);
  this.userList = [];
  this.userCount = 0;
};

util.inherits(ImportAppoint, Service);

module.exports = ImportAppoint;

ImportAppoint.prototype.process =  function(req, res) {
  var self = this;
  if(!req.path) {
    this.onLogicError(1, '请提供文件路径！');
    return;
  }
  var items = [];
  items.push({"key":"code", "value":"用户代码"});
  items.push({"key":"name", "value":"姓名"});
  items.push({"key":"loginname", "value":"登录名"});
  items.push({"key":"post", "value":"职务"});
  items.push({"key":"sex", "value":"性别"});
  items.push({"key":"mobile", "value":"移动电话"});
  items.push({"key":"tel_short", "value":"内部小号"});
  items.push({"key":"tel_work", "value":"办公电话"});
  items.push({"key":"tel_home", "value":"家庭电话"});
  items.push({"key":"tel_other", "value":"其他电话"});
  items.push({"key":"email", "value":"电子信箱"});
  var columns = JSON.parse(req.columns);
  var isCode = false;
  var self = this;
  this.importExcel(req, req.path, function(resFile){
    if(resFile.code!=0) {
      self.onLogicError(resFile.code, resFile.message);
      return;
    }
    var data = resFile.data;
    //处理excel表头
    var title = data[0];
    //循环给对象赋值  
    for(var i=0;i<data.length;i++) {
      if(i<1 || data[i].length<2) continue;
      var row = data[i];
      var user = {};

      for(var j=0;j<row.length;j++){
        for(var x=0;x<items.length;x++){
          if(title[j] == items[x].value){
            var bool = false;
            for(var m=0;m<columns.length;m++){
              if(items[x].value == columns[m]){
                bool = true;
                break;
              }
            }
            if(bool){
              if((title[j] == "用户代码" || title[j] == "姓名" || title[j] == "性别" || title[j] == "登录名") && !(row[j]+'').replace(/ /g,'')){
                self.onLogicError(1, "第"+i+"行“"+title[j]+"”不能为空！");
                return;
              }
              user[items[x].key] = (row[j]+'').replace(/ /g,'');
              if(title[j] == "性别"){
                user[items[x].key] = user[items[x].key] == "男" ? 0 : 1;
              }
              if(title[j] == "用户代码"){
                isCode = true;
              }
              break;
            }
          }
        }
      }
      self.userList.push(user);
    }
    if(self.userList.length==0) {
      self.onLogicError(3, '文件中没有找到用户信息！');
      return;
    }
    if(!isCode){
      self.onLogicError(3, '没有用户代码项，无法导入指定内容！');
      return;
    }

    self.update(req, res);
  });
};

ImportAppoint.prototype.update =  function(req, res) {
  var self = this;
  if(this.userCount==this.userList.length) {
    var params = [];
    for(var i=0;i<this.userList.length;i++) {
      var userNew = this.userList[i];
      params.push({
        modelName: 'user',
        key: userNew.id,
        value: userNew
      });
    }
    req.session.cache.mset(params, function(err) {
      if(err) {
        self.onError(err);
        return;
      }
      self.end(res);
    });
    return;
  }
  var user = this.userList[this.userCount];
  this.userCount++;
  var dao = new User(this);
  dao.query({ 
    where: 'code=\''+user.code+'\' and org_id='+req.session.orgId,
    fields: 'id'
  }, function(rows) {
    if(rows.length>0) {
      dao.update(user, 
        {where: 'code=\''+user.code+'\' and org_id='+req.session.orgId}, function() {
        user.id = rows[0].id;
        self.update(req, res);
      });
    } else {
      self.update(req, res);
    }
  });
};