var Service = require('Service');
var util = require('util');
var Dao = require('../../dao/vuser_viewer');

/**
 * 获得用户查看者列表
 */
var GetViewerList = function () {
  Service.call(this);
};

util.inherits(GetViewerList, Service);

module.exports = GetViewerList;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetViewerList.prototype.process = function (req, res) {
  if (!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }

  var self = this;
  var dao = new Dao(this);
  dao.queryDataPage(req, {
    where: 'org_id=' + req.session.orgId + ' and user_id=' + req.userId
  }, function (dataPage) {
    res.dataPage = dataPage;
    self.emit('end', res);
  });
};