var util = require('util');
var Service = require('Service');
var utils = require('utils');
var AttachDao = require('../../dao/app_attach');

var GetUserHead = function() {
  Service.call(this);
};

util.inherits(GetUserHead, Service);

module.exports = GetUserHead;

GetUserHead.prototype.process =  function(req, res) {
  let user_id = req.session.userId;
  if(req.user_id){
    if(!utils.isInt(req.user_id)) {
      this.onLogicError(1, '请提供正确的用户编号！');
      return;
    }
    user_id = parseInt(req.user_id);
  }
  var self = this;
  req.session.cache.get('user', user_id, function(err, user) {
    if(err) {
      self.onLogicError(2, '请提供正确的用户编号！');
      return;
    }
    var daoAttach = new AttachDao(self);
    daoAttach.query({fields:'code,name',where:'id='+user.head_id}, function(rows) {
      res.data = {};
      if(rows.length==0) {
        res.data.head = {
          url: "/app/sys/console/images/icons/man.png"
        };
        if(user.sex==1) res.data.head.url = "/app/sys/console/images/icons/woman.png";
        //self.onLogicError(4, '没有找到有效的头像！');
        self.end(res);
        return;
      }
      res.data.head = {
        code: rows[0].code,
        name: rows[0].name
      }
      self.end(res);
    });
  });
};