var Service = require('Service');
var util = require('util');
var utils = require('utils');
var User = require('../../dao/vuser');
var Dep = require('../../dao/dep');

/**
 * 获得用户自己的信息
 */
var GetSelfInfo = function() { 
  Service.call(this);
  this.checkAuthority = false;
  this.enableTransaction = false;
};

util.inherits(GetSelfInfo, Service);

module.exports = GetSelfInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetSelfInfo.prototype.process =  function(req, res) {
  var self = this;
  var dao = new User(this);
  dao.query({
    fields:'id,code,name,loginname,mobile,email,motto,sex,post,dep_id as depId,'
      +'create_group,nickname,tel_short,tel_work,tel_home,tel_other',
    where:'org_id='+req.session.orgId+' and id='+req.session.userId}, 
    function(rows) {
    res.user = rows[0];
    self.end(res);
  });
};