var Service = require('Service');
var utils = require('utils');
var UserPost = require('../../dao/user_post');
var util = require('util');

/**
 * 获得用户职务列表
 */
var GetPostList = function () {
  Service.call(this);
};

util.inherits(GetPostList, Service);

module.exports = GetPostList;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetPostList.prototype.process = function (req, res) {
  var self = this;
  var userPost = new UserPost(this);
  userPost.query({
    field: 'id,name,code',
    where: 'org_id=' + req.session.orgId,
    order: 'code asc'
  }, function (rows) {
    res.data = rows;
    self.end(res);
  });
};