var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * App_auth_GetList
 * 获得sys_operate_auth列表
 */
var App_auth_GetList = function() { 
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(App_auth_GetList, Service);

module.exports = App_auth_GetList;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
App_auth_GetList.prototype.process =  function(req , res) {
  //请求参数校验
  if(utils.isNull(req.owner_type)) req.owner_type = 'user';

  var self = this;
  let params = [];
  params.push(req.userId,req.userId,req.userId);
  let where = "";
  if(!utils.isNull(req.app_name)) {
    where += "app_name like ?";
    params.push("%"+req.app_name+"%");
  }
  if(!utils.isNull(req.opration_id)) {
    if(where!="") where += " and ";
    where += "opration_id=?";
    params.push(req.opration_id);
  }
  if(!utils.isNull(req.opration_name)) {
    if(where!="") where += " and ";
    where += "opration_name like ?";
    params.push("%"+req.opration_name+"%");
  }
  if(where!="") where = " and " + where;
  options = {
    sql: "select id,owner_type,owner_id,opration_id,opration_name,owner_name,app_id,app_name "
      +"from vsys_app_auth where ((owner_type='user' and owner_id=?) or "
      +"(owner_type='role' and owner_id in (select role_id from sys_role_user where user_id=?)) "
      +"or (owner_type='dep' and owner_id in (select dep_id from sys_dep_user where user_id=?))) "+where+"",
    params: params,
    count_sql: "select count(*) as count_ from (select id,owner_type,owner_id,opration_id,"
      +"opration_name,owner_name,app_id,app_name from vsys_app_auth where ((owner_type='user' and owner_id=?) "
      +"or (owner_type='role' and owner_id in (select role_id from sys_role_user where user_id=?)) "
      +"or (owner_type='dep' and owner_id in (select dep_id from sys_dep_user where user_id=?))) "+where+") count_rows ",
    count_params: params,
    order: "owner_type asc,owner_id asc,app_id asc,opration_id asc"
  };
  self._dao.queryDataPage(
    req, options,
    function(rows) {
    res.data = rows;
    self.end(res);
  });
};
