var Service = require('Service');
var util = require('util');

/**
 * 获得在线用户信息
 */
var GetOnlineUsers = function () {
  Service.call(this);
  this.connectDb = false;
};

util.inherits(GetOnlineUsers, Service);

module.exports = GetOnlineUsers;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetOnlineUsers.prototype.process = function (req, res) {
  res.users = [];
  var userId = '';

  for (userId in req.session.org.users) {
    var user = req.session.org.users[userId];
    if (user.imStatus == 'online') {
      var userTmp = {};
      if (req.keyword) {
        var t = user.name.indexOf(req.keyword);
        if (t >= 0) {
          userTmp.id = user.id;
          userTmp.code = user.code;
          userTmp.name = user.name;
          userTmp.sex = user.sex;
          userTmp.depName = '';
          if (user.deps.length > 0) {
            var dep = req.session.org.deps[user.deps[0]];
            if (dep) {
              userTmp.depName = dep.name;
            } else {
              user.deps.shift();
            }
          }
          res.users.push(userTmp);
        }
      } else {
        userTmp.id = user.id;
        userTmp.code = user.code;
        userTmp.name = user.name;
        userTmp.sex = user.sex;
        userTmp.depName = '';
        if (user.deps.length > 0) {
          var dep = req.session.org.deps[user.deps[0]];
          if (dep) {
            userTmp.depName = dep.name;
          } else {
            user.deps.shift();
          }
        }
        res.users.push(userTmp);
      }
    }
  }
  this.end(res);
};