var util = require('util');
var Service = require('Service');
var utils = require('utils');

var GetOnlineStatus = function () {
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetOnlineStatus, Service);

module.exports = GetOnlineStatus;

GetOnlineStatus.prototype.process = function (req, res) {
  if (!req.usersId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  //用户所谓的在线状态是不精确的，只是一个相对状态，不是实时的
  //因为客户端与服务器没有长连接一直保持
  //无法严格意义上判断是否真的在线，只能根据最后活跃时间来判断最近一段时间内是否和服务器交互过
  res.status = [];
  for (var i = 0; i < req.usersId.length; i++) {
    var userSession = server.sessionManager.onlineUsers[req.session.orgId+'.'+req.usersId[i]];
    if (!userSession) {
      res.status.push([0,0,0]);
      continue;
    }
    var web = 0;
    if (userSession.web && userSession.web.length>0) web = 1;
    var pc = 0;
    if (userSession.pc) pc = 1;
    var mobile = 0;
    if (userSession.phone || userSession.pad) mobile = 1;
    res.status.push([web, pc, mobile]);
  }
  this.end(res);
};