var Service = require('Service');
var util = require('util');
var utils = require('utils');
var User = require('../../dao/vuser');
var Dep = require('../../dao/dep');

/**
 * 获得用户列表
 */
var GetList = function() { 
  Service.call(this);
  this.enableTransaction = false;
  this.idStr = '';
};

util.inherits(GetList, Service);

module.exports = GetList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetList.prototype.process =  function(req, res) {
  if(req.depId) {
    var depIds = utils.strToIntArray(req.depId);
    if(depIds.length==0) {
      this.getListUsers(req, res);
      return;
    }
    this.getListDeps(req, res, depIds.join());
  }else{
    this.getListUsers(req, res);
  }
};

GetList.prototype.getListDeps =  function(req, res, ids) {
  var self = this;
  if(this.idStr) this.idStr += ',';
//       self.idStr += rows[0].id;
  this.idStr += ids;
  var dep = new Dep(this);
  dep.query({fields:'id', where:'org_id='
    +req.session.orgId+' and parent_id in ('+ids+')'}, function(rows) {
      var ids = [];
      for(var i = 0; i < rows.length; i++) ids.push(rows[i].id);
    if(ids.length == 0){
      self.getListUsers(req, res);
    }else{
      self.getListDeps(req, res, ids.join());
    }
  });
};

GetList.prototype.getListUsers =  function(req, res) {
  var self = this;
  var where = 'org_id='+req.session.orgId;
  if(utils.isInt(req.status)) {
    where += ' and status='+parseInt(req.status);
  } else if(req.showAll == "N"){
    where += ' and status=0 ';
  } else {
    where += ' and (status=0 or status=2) ';
  }
  if(req.depId && req.depId>0) {
    where += ' and id in (select user_id from sys_dep_user '
      +'where org_id='+req.session.orgId+' and dep_id in ('+this.idStr+'))';
  }
  var params = null;
  if(req.keyword) {
    where += ' and (code like ? or name like ? or loginname like ? or post like ?)';
    var keyword = '%'+req.keyword+'%';
    params = [keyword,keyword,keyword,keyword];
  }
  var userDao = new User(this);
  
  if(req.isExport){//导出excel
    userDao.query({where: where,fields: 
      'id,code,name,loginname,mobile,sex,post,'+
      'tel_short,tel_work,tel_home,tel_other,email,dep_name',
      order: 'code+0 ASC,code asc',
      params:params}, function(rows) {
        var datas = [];
        var columns = ["用户代码","姓名","性别","登录名","职务","移动电话","内部小号","办公电话","家庭电话","其他电话","电子信箱","部门名称"];
        datas.push(columns);
        for(var i=0;i<rows.length;i++) {
          var row = [];
          row.push(rows[i].code);//
          row.push(rows[i].name);//
          row.push(rows[i].sex==0?'男':'女');//
          row.push(rows[i].loginname);//
          row.push(rows[i].post);//
          row.push(rows[i].mobile);//
          row.push(rows[i].tel_short);
          row.push(rows[i].tel_work);
          row.push(rows[i].tel_home);
          row.push(rows[i].tel_other);
          row.push(rows[i].email);
          row.push(rows[i].dep_name);

          datas.push(row);
        }
        //datas.push(["查询条件:手机"+req.mobile+"地址"+req.provinceName+req.cityName+req.districtName]);

        var args = {};
        args.data = datas;
        args.appCode = 'userInfo';
        args.fileName = '用户信息'+(new Date()).format('_yyyyMMddhhmmss')+'.xlsx';
        self.exportExcel(req, args, function(resIM) {
          self.end(resIM);
        });
    });
  }else{
    userDao.queryDataPage(req, { 
      where: where,
      fields: 'id,code,name,loginname,mobile,sex,post,status,dep_name',
      order: 'code',
      params: params
    }, function(dataPage) {
      res.dataPage = dataPage;
      self.end(res);
    });
  }
};