var Service = require('Service');
var utils = require('utils');
var DaoUser = require('../../dao/user');
var util = require('util');

/**
 * 获得最后修改过密码的用户列表
 */
var getLastUpdatePwd = function () {
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(getLastUpdatePwd, Service);

module.exports = getLastUpdatePwd;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
getLastUpdatePwd.prototype.process = function (req, res, cb) {
  if (!req.lastUpdateTime) {
    this.onLogicError(1, '请提供最后修改时间！');
    return;
  }

  var self = this;
  var dao = new DaoUser(this);
  dao.query({
    fields: 'id,code,password',
    where: 'org_id=' + req.session.orgId +
      ' and last_update_pwd is not null and last_update_pwd>=\'' +
      req.lastUpdateTime + '\''
  }, function (rows) {
    res.list = rows;
    res.time = new Date();
    self.end(res);
  });
};