var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/user');
var util = require('util');

/**
 * 获得用户头像编号
 */
var GetHeadId = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetHeadId, Service);

module.exports = GetHeadId;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetHeadId.prototype.process =  function(req, res) {
  var self = this;
  var dao = new User(this);
  dao.query({
    fields:'head_id',
    where:'org_id='+req.session.orgId+' and id='+req.session.userId}, 
    function(rows) {
    if(rows.length==0) {
      res.headId = 0;
    } else {
      res.headId = rows[0].head_id;
      //if(req.session.user.head_id!=res.headId) req.session.user.head_id = res.headId;
    }
    
    self.emit('end', res);
  });
};