var Service = require('Service');
var utils = require('utils');
var UserFriend = require('../../dao/vuser_friend');
var util = require('util');

/**
 * 获得好友列表
 */
var GetFriends = function () {
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetFriends, Service);

module.exports = GetFriends;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetFriends.prototype.process = function (req, res) {
  var self = this;
  var daoFriend = new UserFriend(this);
  daoFriend.execute('select a.friend_id,a.friend_name,a.friend_sex,' +
    'a.friend_comment,a.msg_top,a.msg_no_hint,b.id,b.code,b.name,' +
    'b.head_id,b.sex from vsys_user_friend a,sys_user b where ' +
    'a.org_id=b.org_id and a.friend_id=b.id and a.org_id=' +
    req.session.orgId + ' and a.user_id=' + req.session.userId,
    null,
    function (rows) {
      res.friends = [];
      for (var i = 0; i < rows.length; i++) {
        res.friends.push([rows[i].id, rows[i].code, rows[i].name,
          rows[i].head_id, rows[i].sex, rows[i].friend_comment,
          rows[i].msg_top, rows[i].msg_no_hint
        ]);
      }
      self.end(res);
    });
};