var util = require('util');
var Service = require('Service');
var utils = require('utils');
var Dao = require('../../dao/user');

var GetEmail = function () {
  Service.call(this);
};

util.inherits(GetEmail, Service);

module.exports = GetEmail;

GetEmail.prototype.process = function (req, res) {
  if (!req.ids) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }

  var self = this;
  var dao = new Dao(this);
  dao.query({
    fields: 'id,name,email',
    where: 'org_id=' + req.session.orgId + ' and id in (' + req.ids + ')'
  }, function (rows) {
    res.data = rows;
    self.end(res);
  });
};