var Service = require('Service');
var util = require('util');
var User = require('../../dao/vuser');
var UserPost = require('../../dao/user_post');
var Dep = require('../../dao/dep');

/**
 * 获得用户桌面信息
 */
var GetDesktopInfo = function () {
  Service.call(this);
  this.checkAuthority = false;
  this.enableTransaction = false;
};

util.inherits(GetDesktopInfo, Service);

module.exports = GetDesktopInfo;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetDesktopInfo.prototype.process = function (req, res) {
  var self = this;
  res.username = req.session.user.name;
  self.getUserDiskInfo(req, res, req.session, function (di) {
    res.di = di;
    self.pipe(require('../app/getMyAppList'), req, res);
  });
};