var Service = require('Service');
var utils = require('utils');
var Dep = require('../../dao/dep');
var util = require('util');

/**
 * 获得用户所在部门列表
 */
var getDepList = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(getDepList, Service);

module.exports = getDepList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
getDepList.prototype.process =  function(req, res, cb) {
  if(!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  if(!utils.isInt(req.userId)) {
    this.onLogicError(2, '请提供正确的用户编号！');
    return;
  }

  res.deps = [];
  var self = this;
  var daoDep = new Dep(self);
  daoDep.query({where:'org_id='+req.session.orgId+' and id in '
    +'(select dep_id from sys_dep_user where org_id='+req.session.orgId
    +' and user_id='+req.userId+')'}, function(rows) {
    for(var i=0;i<rows.length;i++) {
      var depTmp = {};
      depTmp.id = rows[i].id;
      depTmp.code = rows[i].code;
      depTmp.name = rows[i].name;
      depTmp.description = rows[i].description;
      res.deps.push(depTmp);
    }
    self.emit('end', res);
  });
};