var Service = require('Service');
var utils = require('utils');
var util = require('util');

/**
 * 获得当前用户详细信息
 */
var GetCurUser = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetCurUser, Service);

module.exports = GetCurUser;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetCurUser.prototype.process =  function(req, res) {
  var self = this;
  req.session.cache.getList('user', {fields: 'id,code,name,loginname,sex,head_id,'
    +'mobile,email,motto,post,nickname,tel_short,tel_work,tel_home,tel_other', 
    where: '#{id}=='+req.session.userId}, function(err, users) {
    if(err) {
      self.onLogicError(1, err.message);
      return;
    }
    if(users.length==0) {
      self.onLogicError(3, '用户信息不存在。');
      return;
    }
    res.user = users[0];
    res.user.depId = req.session.userDepId;
    res.user.depCode = req.session.userDepCode;
    res.user.depName = req.session.userDepName;
    res.userDeps = req.session.userDeps;
    res.userRoles = req.session.userRoles;
    self.end(res);
  });
};