var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/vuser');
var Dep = require('../../dao/dep');
var AttachDao = require('../../dao/app_attach');
var util = require('util');

/**
 * 获得用户详细信息
 */
var GetByCode = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetByCode, Service);

module.exports = GetByCode;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetByCode.prototype.process =  function(req, res) {
  if(!req.code) {
    this.onLogicError(1, '请提供用户代码！');
    return;
  }

  var self = this;
  var dao = new User(this);
  dao.query({
    fields:'id,code,name,mobile,email,motto,sex,post,dep_id,head_id,'+
    'nickname,tel_short,tel_work,tel_home,tel_other,status',
    where:'org_id='+req.session.orgId+' and code=? and (status=0 or status=2)', 
    params:[req.code]}, function(rows) {
    if(rows.length==0) {
      self.onLogicError(2, '请提供正确的用户代码！');
      return;
    }
    res.user = rows[0];
    self.end(res);
  });
};