var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/user');
var util = require('util');

/**
 * 获得用户权限信息
 */
var GetAuth = function () {
  Service.call(this);
};

util.inherits(GetAuth, Service);

module.exports = GetAuth;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetAuth.prototype.process = function (req, res) {
  if (!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }

  var self = this;
  var dao = new User(this);
  dao.query({
      fields: 'create_group,look_all,look_self_bureau,look_self_dep,look_leader,look_under',
      where: 'org_id=' + req.session.orgId + ' and id=' + req.userId
    },
    function (rows) {
      if (rows.length == 0) {
        self.onLogicError(2, '请提供正确的用户编号！');
        return;
      }
      res.auth = rows[0];

      self.emit('end', res);
    });
};