var Service = require('Service');
var util = require('util');
var Dao = require('../../dao/vapp_auth');

/**
 * 获得应用列表
 */
var GetList = function () {
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetList, Service);

module.exports = GetList;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetList.prototype.process = function (req, res) {
  var self = this;
  if (global.server.id == 'IMServer') {
    this.pipe(require('../app/getMyAppList'), req, res, function (req2, res2) {
      self.onGetApps(req2, res2);
    });
  } else {
    this.requestIMService('sys/service/app/getMyAppList', {}, req, function (resIM) {
      self.onGetApps(req, resIM);
    });
  }
};

GetList.prototype.onGetApps = function (req, res) {
  if (res.code != 0) {
    this.onLogicError(res.code, res.message);
    return;
  }
  for (var i = 0; i < res.apps.length; i++) {
    var app = res.apps[i];
    if (req.session.clientType == 'androidphone' || req.session.clientType == 'iphone') {
      app.url = app.url_phone;
      app.detailUrl = app.url_phone_detail;
    } else if (req.session.clientType == 'androidpad' || req.session.clientType == 'ipad') {
      app.url = app.url_pad;
      app.detailUrl = app.url_pad_detail;
    } else if (req.session.clientType == 'pc') {
      app.url = app.url_pcc;
      app.detailUrl = app.url_pcc_detail;
    } else {
      app.url = app.url_pc;
      app.detailUrl = app.url_pc_detail;
    }
  }
  this.end(res);
};

GetList.prototype.process2 = function (req, res) {
  var fields = 'app_code,app_name,version,deploy,icon_path,' +
    'icon_code,titlebar_color,msg_group,get_badge_service,';
  var where = 'org_id=' + req.session.orgId + ' and status=0 and ' +
    '(opration_id is null or opration_id=0) and ' +
    '((owner_type=\'用户\' and owner_id=' + req.session.userId + ') ' +
    'or (owner_type=\'角色\' and owner_id in (select role_id from ' +
    'sys_role_user where user_id=' + req.session.userId + ')) ' +
    'or (owner_type=\'部门\' and owner_id in (select dep_id from ' +
    'sys_dep_user where user_id=' + req.session.userId + ')))';
  if (req.session.clientType == 'androidphone' || req.session.clientType == 'iphone') {
    fields += 'url_phone as url,url_phone_detail as detailUrl';
    where += ' and terminal like \'%手机%\' and auth_terminal in (\'all\',\'mobile\')';
  } else if (req.session.clientType == 'androidpad' || req.session.clientType == 'ipad') {
    fields += 'url_pad as url,url_pad_detail as detailUrl';
    where += ' and terminal like \'%平板%\' and auth_terminal in (\'all\',\'mobile\')';
  } else if (req.session.clientType == 'pc') {
    fields += 'url_pcc as url,url_pcc_detail as detailUrl';
    where += ' and terminal like \'%电脑%\' and auth_terminal in (\'all\',\'pcc\')';
  } else {
    fields += 'url_pc as url,url_pc_detail as detailUrl';
    where += ' and terminal like \'%管理%\' and auth_terminal in (\'all\',\'pc\')';
  }

  var self = this;
  var dao = new Dao(this);
  dao.query({
    distinct: true,
    fields: fields,
    where: where,
    order: 'order_no asc,app_id asc'
  }, function (rows) {
    res.apps = rows;
    self.end(res);
  });
};