var Service = require('Service');
var utils = require('utils');
//var AttachDao = require('../../dao/app_attach');
var util = require('util');

/**
 * 获得用户详细信息
 */
var Get = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process =  function(req, res) {
  if(!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  if(!utils.isInt(req.userId)) {
    this.onLogicError(2, '请提供正确的用户编号！');
    return;
  }

  var self = this;
  req.session.cache.getList('user', {fields: 'id,code,name,loginname,sex,head_id,'
    +'mobile,email,motto,post,nickname,tel_short,tel_work,tel_home,tel_other', 
    where: '#{id}=='+req.userId}, function(err, users) {
    if(err) {
      self.onLogicError(3, err.message);
      return;
    }

    if(users.length==0) {
      self.onLogicError(3, '用户编号：'+req.userId+'不存在。');
      return;
    }
    res.user = users[0];
    res.user.netstatus = '离线';
    //if(user.imStatus == 'online') res.user.netstatus = '在线';
    //res.dep_name = '';
    /*for(var i=0;i<user.deps.length;i++) {
      if(i>0) res.dep_name += '、';
      var dep = req.session.org.deps[user.deps[i]];
      if(dep) {
        res.dep_name += dep.name;
      }
    }*/

    res.bgWall = '';
    self.end(res);
    /*var daoAttach = new AttachDao(self);
    daoAttach.query({fields: 'code', where: 'org_id='
      +req.session.orgId+' and app_code="workcircle.bgWall" '
      +'and uploader_id='+req.userId, order: 'id desc', limit: 1}, function(rows2) {
      if(rows2.length>0) res.bgWall = rows2[0].code;
      self.end(res);
    });*/
  });
};