var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/user');
var VUser = require('../../dao/vuser');
var DepUser = require('../../dao/dep_user');
var RoleUser = require('../../dao/role_user');
var UserSubDep = require('../../dao/user_subdep');
var Org = require('../../dao/org');
var util = require('util');
var crypto = require('crypto');

/**
 * 启用用户
 */
var Enable = function() { 
  Service.call(this);
  this.index = 0;
  this.count = 0;
  this.arrUserId = [];
};

util.inherits(Enable, Service);

module.exports = Enable;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Enable.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  
  var userIds = utils.strToIntArray(req.id);
  if(userIds.length==0) {
    this.onLogicError(2, '请提供用户编号！');
    return;
  }
  userIds = userIds.join();

  var self = this;
  //server.lcManager.checkUserCount(req, function(code, err) {
  //  if(code!=0) {
  //    self.onLogicError(8, err, req, res, cb);
  //    return;
  //  }
    self.getUser(req, res, userIds);
  //});
};

Enable.prototype.getUser =  function(req, res, userIds) {
  var self = this;
  var dao = new User(this);
  dao.update({status: 0}, {where: 'id in ('+userIds
    +') and org_id='+req.session.orgId }, function() {
    var orgDao = new Org(self);
    orgDao.setLastUpdate(req.session.orgId, function(lastUpdate) {
      var daoVUser = new VUser(self);
      daoVUser.query({fields: 'id,code,name,loginname,org_id,sex,head_id,'
        +'post,motto,mobile,nickname,email,tel_short,tel_work,password', 
        where: 'id in ('+userIds+') and org_id='+req.session.orgId}, function(users){
        if(users.length==0) {
          self.emit('end', res);
          return;
        }
        self.count = users.length;
        //for(var i=0;i<users.length;i++) {
          self.enableUser(req, res, users, 0, lastUpdate);
        //}
      });
    });
  });
};

/**
 * 清除会话
 * @param  {Object} req        请求对象
 * @param  {String} sessionId  会话编号
 */
Enable.prototype.enableUser =  function(req, res, users, userIndex, lastUpdate) {
  if(userIndex>=users.length) {
    this.end(res);
    return;
  }
  var user = users[userIndex];
  user['deps'] = [];
  user['roles'] = [];
  user['subDeps'] = [];
  var self = this;
  //查询部门信息
  var daoDepUser = new DepUser(this);
  daoDepUser.query({fields:'dep_id', where:'org_id='+req.session.orgId
    +' and user_id='+user.id+' and dep_id in (select id from sys_dep '
    +'where org_id='+req.session.orgId+' and status=0)'}, function(deps){
    for(var i=0;i<deps.length;i++) {
      user.deps.push(deps[i].dep_id);
    }
    //查询角色信息
    var daoRoleUser = new RoleUser(self);
    daoRoleUser.query({fields:'role_id', where:'org_id='+req.session.orgId
      +' and user_id='+user.id+' and role_id in (select id from sys_role '
      +'where org_id='+req.session.orgId+' and status=0)'}, function(roles){
      for(var i=0;i<roles.length;i++) {
        user.roles.push(roles[i].role_id);
      }
      var daoUserSubDep = new UserSubDep(self);
      daoUserSubDep.query({fields:'dep_id', where:'org_id='+req.session.orgId
        +' and user_id='+user.id+' and dep_id in (select id from sys_dep '
        +'where org_id='+req.session.orgId+' and status=0)'}, function(subDeps){
        for(var i=0;i<subDeps.length;i++) {
          user.subDeps.push(subDeps[i].dep_id);
        }
        req.session.cache.set('user', user.id, user, false, function(err){
          if(err) {
            self.onLogicError(6, err.message, req, res, cb);
            return;
          }
          self.enableUser(req, res, users, userIndex+1, lastUpdate);
        });
      });
    });
  });
};