var util = require('util');
var Service = require('Service');
var utils = require('utils');

var DownLoadFile = function () {
  Service.call(this);
};

util.inherits(DownLoadFile, Service);

module.exports = DownLoadFile;

DownLoadFile.prototype.process = function (req, res) {
  var self = this;
  var datas = [];
  var columns = JSON.parse(req.columns);
  var styles = {
    headerDark: {
      //     fill: {
      //       fgColor: {
      //         rgb: 'FFFFFFFF'
      //       }
      //     },
      font: {
        //       color: {
        //         rgb: 'FFFFFFFF'
        //       },
        //       sz: 20
        //       bold: true,
        //       underline: true
      }
    },
    cellPink: {
      fill: {
        bgColor: {
          rgb: 'FFFFCCFF'
        }
      }
    },
    cellGreen: {
      fill: {
        fgColor: {
          rgb: 'FF00FF00'
        }
      }
    }
  };
  var heading = [
    //     [{value: 'a1', style: styles.headerDark}, {value: 'b1', style: styles.headerDark}, {value: 'c1', style: styles.headerDark}],
    //     ['a2', 'b2', 'c2'] // <-- It can be only values 
  ];
  var specification = {
    //   customer_name: { // <- the key should match the actual data key 
    //     displayName: 'Customer', // <- 标题
    //     headerStyle: styles.headerDark, // <- 样式
    //     cellStyle: function(value, row) { // <- style renderer function 
    //       // if the status is 1 then color in green else color in red 
    //       // Notice how we use another cell value to style the current one 
    //       return (row.status_id == 1) ? styles.cellGreen : {fill: {fgColor: {rgb: 'FFFF0000'}}}; // <- Inline cell style is possible  
    //     },
    //     width: 120 // <- width in pixels 
    //   },
    //   status_id: {
    //     displayName: 'Status',
    //     headerStyle: styles.headerDark,
    //     cellFormat: function(value, row) { // <- 格式化内容 
    //       return (value == 1) ? 'Active' : 'Inactive';
    //     },
    //     width: '10' // <- width in chars (when the number is passed as string) 
    //   },
    //   note: {
    //     displayName: 'Description',
    //     headerStyle: styles.headerDark,
    //     cellStyle: styles.cellPink, // <- Cell style 
    //     width: 220 // <- width in pixels 
    //   }
    //   note: {
    //     displayName: 'Description',
    //     headerStyle: styles.headerDark,
    //     cellStyle: styles.cellPink, // <- Cell style 
    //     width: 220 // <- width in pixels 
    //   }
    //     code: {
    //     displayName: '用户代码(工号)',
    //     headerStyle: styles.headerDark,
    //     width: 150 // <- width in pixels 
    //   },name: {
    //     displayName: '姓名',
    //     headerStyle: styles.headerDark,
    //     width: 150 // <- width in pixels 
    //   },loginname: {
    //     displayName: '登录名',
    //     headerStyle: styles.headerDark,
    //     width: 150 // <- width in pixels 
    //   }
  };
  var items = [];
  items.push({
    "key": "code",
    "value": "用户代码"
  });
  items.push({
    "key": "name",
    "value": "姓名"
  });
  items.push({
    "key": "loginname",
    "value": "登录名"
  });
  items.push({
    "key": "post",
    "value": "职务"
  });
  items.push({
    "key": "sex",
    "value": "性别"
  });
  items.push({
    "key": "mobile",
    "value": "移动电话"
  });
  items.push({
    "key": "tel_short",
    "value": "内部小号"
  });
  items.push({
    "key": "tel_work",
    "value": "办公电话"
  });
  items.push({
    "key": "tel_home",
    "value": "家庭电话"
  });
  items.push({
    "key": "tel_other",
    "value": "其他电话"
  });
  items.push({
    "key": "email",
    "value": "电子信箱"
  });

  for (var i = 0; i < columns.length; i++) {
    for (var j = 0; j < items.length; j++) {
      if (columns[i] == items[j].value) {
        var obj = {
          displayName: items[j].value,
          width: 100,
          headerStyle: styles.headerDark
        };
        specification[items[j].key] = obj;
      }
    }
  }

  var args = {};
  args.sheets = [{
    name: 'Sheet1', // <- Specify sheet name (optional) 
    heading: heading, // <- Raw heading array (optional) 
    specification: specification, // <- Report specification 
    data: [] // <-- Report data 
  }];
  args.appCode = 'userInfo';
  args.fileName = '导出信息' + (new Date()).format('_yyyyMMddhhmmss') + '.xlsx';
  this.exportExcel(req, args, function (resIM) {
    self.end(resIM);
  });

  /*var dataset = [];
  var buffer = excel.buildExport();
  var fileCode = uuid.v1().replace(/-/g,'');
  var rootpath = process.cwd();
  var filepath = '/'+((app.config.attach 
    && app.config.attach.dir)?app.config.attach.dir:'files')
    +'/'+req.session.org.code+'/';
  if(!fs.existsSync(rootpath+filepath)) fs.mkdirSync(rootpath+filepath);
  filepath += 'output.userInfo/';
  if(!fs.existsSync(rootpath+filepath)) fs.mkdirSync(rootpath+filepath);

  var filePath = app.getPath('/'+((app.config.attach 
    && app.config.attach.dir)?app.config.attach.dir:'files')
    +'/'+ req.session.org.code +'/output.userInfo/'+fileCode+'.file');
  fs.writeFileSync(filePath, buffer, 'binary');
  
  var stat = fs.statSync(filePath);
  var attach = {};
  attach.code = fileCode;
  attach.name = 'userInfo.xlsx';
  attach.size = stat.size;
  attach.type = path.extname('userInfo.xlsx');
  attach.app_code = 'output.userInfo';
  attach.app_data_id = 0;
  attach.uploader_id = req.session.userId;
  attach.uploader_name = req.session.user.name;
  attach.upload_time = new Date();      
  attach.save_path = '/'+((app.config.attach 
    && app.config.attach.dir)?app.config.attach.dir:'files')
    +'/'+ req.session.org.code +'/output.userInfo/'
    +fileCode+'.file'.replace(/\\/g,'/');
  attach.org_id = req.session.orgId;

  var attachDao = new AppAttachDao(this);
  attachDao.create(attach, function(ret) {
    res.fileCode = attach.code;
    res.fileSize = attach.size;
    res.fileName = attach.name;
    res.fileId = ret.insertId;
    self.end(res);
  });  
  */
};