var util = require('util');
var Service = require('Service');
var utils = require('utils');

var DownLoadFile = function() {
  Service.call(this);
};

util.inherits(DownLoadFile, Service);

module.exports = DownLoadFile;

DownLoadFile.prototype.process =  function(req, res) {
  var self = this;
  var datas = [];
  var columns = JSON.parse(req.columns);
  var styles = {
  headerDark: {
  //     fill: {
  //       fgColor: {
  //         rgb: 'FFFFFFFF'
  //       }
  //     },
      font: {
  //       color: {
  //         rgb: 'FFFFFFFF'
  //       },
  //       sz: 20
  //       bold: true,
  //       underline: true
      }
    },
    cellPink: {
      fill: {
        bgColor: {
          rgb: 'FFFFCCFF'
        }
      }
    },
    cellGreen: {
      fill: {
        fgColor: {
          rgb: 'FF00FF00'
        }
      }
    }
  };
  var heading = [];
  var specification = {};
  var items = [];
  items.push({"key":"code", "value":"用户代码"});
  items.push({"key":"name", "value":"姓名"});
  items.push({"key":"loginname", "value":"登录名"});
  items.push({"key":"post", "value":"职务"});
  items.push({"key":"sex", "value":"性别"});
  items.push({"key":"mobile", "value":"移动电话"});
  items.push({"key":"tel_short", "value":"内部小号"});
  items.push({"key":"tel_work", "value":"办公电话"});
  items.push({"key":"tel_home", "value":"家庭电话"});
  items.push({"key":"tel_other", "value":"其他电话"});
  items.push({"key":"email", "value":"电子信箱"});

  for(var i=0;i<columns.length;i++){
    for(var j=0;j<items.length;j++){
      if(columns[i] == items[j].value){
        var obj = {displayName:items[j].value, width:100, headerStyle: styles.headerDark};
        specification[items[j].key] = obj;
      }
    }
  }
  
  var args = {};
  args.sheets = [
    {
      name: 'Sheet1', // <- Specify sheet name (optional) 
      heading: heading, // <- Raw heading array (optional) 
      specification: specification, // <- Report specification 
      data: [] // <-- Report data 
    }
  ];
  args.appCode = 'userInfo';
  args.fileName = '导出信息'+(new Date()).format('_yyyyMMddhhmmss')+'.xlsx';
  this.exportExcel(req, args, function(resIM) {
    self.end(resIM);
  });
};