var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/user');
var Org = require('../../dao/org');
var util = require('util');

/**
 * 禁用用户
 */
var Disable = function() { 
  Service.call(this);
};

util.inherits(Disable, Service);

module.exports = Disable;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Disable.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  var userIds = utils.strToIntArray(req.id);
  if(userIds.length==0) {
    this.onLogicError(2, '请提供用户编号！');
    return;
  }
  userIds = userIds.join();

  var self = this;
  var dao = new User(this);
  dao.update({status: 2}, {where: 'id in ('+userIds+') and loginname<>\'admin\' '
    +'and org_id='+req.session.orgId }, function() {
    var orgDao = new Org(self);
    orgDao.setLastUpdate(req.session.orgId, function(lastUpdate) {
      req.session.cache.del('user','['+userIds+'].contains(#{id}) && #{loginname}!="admin"', function(err){
        if(err) {
          self.onError(err);
          return;
        }
        self.end(res);
      });
    });
  });
};