var Service = require('Service');
var utils = require('utils');
var Dao = require('../../dao/user_viewer');
var util = require('util');

/**
 *  删除用户查看者
 */
var DeleteViewer = function () {
  Service.call(this);
  this.dao = new Dao(this);
};

util.inherits(DeleteViewer, Service);

module.exports = DeleteViewer;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
DeleteViewer.prototype.process = function (req, res) {

  if (!req.id) {
    this.onLogicError(1, '请提供观察者编号！');
    return;
  }

  if (!req.userId) {
    this.onLogicError(2, '请提供用户编号！');
    return;
  }

  var self = this;
  this.dao.delete('org_id=' + req.session.orgId + ' and user_id=' +
    req.userId + ' and id in (' + req.id + ')',
    function () {
      self.emit('end', res);
    });
};