var Service = require('Service');
var utils = require('utils');
var UserDao = require('../../dao/user');
var UserPostDao = require('../../dao/user_post');
var util = require('util');

/**
 * 修改职务
 */
var UpdatePost = function () {
  Service.call(this);
};

util.inherits(UpdatePost, Service);

module.exports = UpdatePost;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
UpdatePost.prototype.process = function (req, res, cb) {
  if (!req.id) {
    this.onLogicError(1, '请提供编号！');
    return;
  }

  var self = this;
  var daoUser = new UserDao(this);
  var daoUserPost = new UserPostDao(this);
  daoUser.query({
    where: 'org_id=' + req.session.orgId + ' and post=(select name from ' +
      'sys_user_post where org_id=' + req.session.orgId + ' and id=' + req.id + ')',
    fields: 'id'
  }, function (rows) {
    if (rows.length > 0) {
      self.onLogicError(2, '有用户信息使用了该职务，目前不能删除！');
      return;
    }
    daoUserPost.delete('org_id=' + req.session.orgId + ' and id=' + req.id, function () {
      self.end(res);
    });
  });
};