var Service = require('Service');
var utils = require('utils');
var UserFriend = require('../../dao/user_friend');
var util = require('util');

/**
 * 删除好友
 */
var DeleteFriend = function () {
  Service.call(this);
};

util.inherits(DeleteFriend, Service);

module.exports = DeleteFriend;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
DeleteFriend.prototype.process = function (req, res) {
  if (!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }

  var self = this;
  var daoFriend = new UserFriend(this);
  daoFriend.delete('org_id=' + req.session.orgId + ' and ((user_id=' +
    req.session.userId + ' and friend_id=' + req.userId + ') or user_id=' +
    req.userId + ' and friend_id=' + req.session.userId + ')',
    function () {
      req.appCode = 'sys';
      req.appDataType = 'user/deleteFriend';
      req.receiversId = '' + req.userId;
      req.message = req.session.user.name + '已与您解除好友关系';
      self.sendAppMsg(req, res);
    });
};