var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/user');
var Org = require('../../dao/org');
var util = require('util');

/**
 * 删除用户
 */
var Delete = function() { 
  Service.call(this);
};

util.inherits(Delete, Service);

module.exports = Delete;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Delete.prototype.process =  function(req, res, cb) {
  if(!req.id) {
    this.onLogicError(1, '请提供用户编号！', req, res, cb);
    return;
  }
  var userIds = utils.strToIntArray(req.id);
  if(userIds.length==0) {
    this.onLogicError(2, '请提供用户编号！');
    return;
  }

  var self = this;
  var dao = new User(this);
  dao.update({status: 1}, {where: 'id in ('+userIds.join()+') and loginname<>\'admin\' '
    +'and org_id='+req.session.orgId }, function() {
    var orgDao = new Org(self);
    orgDao.setLastUpdate(req.session.orgId, function(lastUpdate) {
      req.session.cache.del('user','['+userIds.join()+'].contains(#{id}) && #{loginname}!="admin"', function(err){
        if(err) {
          self.onError(err);
          return;
        }
        if(cb) {
          cb(req, res);
        } else {
          self.end(res);
        }
      });
    });
  });
};