var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/user');
var util = require('util');

/**
 * 申请加为好友
 */
var ApplyAddFriend = function () {
  Service.call(this);
};

util.inherits(ApplyAddFriend, Service);

module.exports = ApplyAddFriend;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
ApplyAddFriend.prototype.process = function (req, res) {
  if (!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }

  var self = this;
  var daoUser = new User(this);
  daoUser.query({
    fields: 'id,name',
    where: 'org_id=' + req.session.orgId +
      ' and id=' + req.userId
  }, function (rowsUser) {
    if (rowsUser.length == 0) {
      self.onLogicError(2, '用户不存在！');
      return;
    }

    req.appCode = 'sys';
    req.appDataType = 'user/applyAddFriend';
    req.receiversId = '' + req.userId;
    req.content = req.session.user.name;
    req.message = req.session.user.name + '请求添加您为好友';
    self.sendAppMsg(req, res);
  });
};