var Service = require('Service');
var utils = require('utils');
var UserSubDep = require('../../dao/user_subdep');
var Org = require('../../dao/org');
var util = require('util');

/**
 * 添加用户管辖部门
 */
var AddSubDep = function() { 
  Service.call(this);
  this.arrDepId;      //部门数组
  this.depCount = 0;  //部门总数
  this.depIndex = 0;  //部门索引
};

util.inherits(AddSubDep, Service);

module.exports = AddSubDep;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
AddSubDep.prototype.process =  function(req, res) {
  if(!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  if(!utils.isInt(req.userId)) {
    this.onLogicError(2, '请提供正确的用户编号！');
    return;
  }
  if(!req.depIdList) {
    this.onLogicError(3, '请提供部门编号！');
    return;
  }
  var depIds = utils.strToIntArray(req.depIdList);
  if(depIds.length==0) {
    this.onLogicError(3, '请提供部门编号！');
    return;
  }
  depIds = depIds.join();

  var self = this;
  var dao = new UserSubDep(this);
  dao.execute('delete from sys_user_subdep where org_id='+req.session.orgId
    +' and user_id='+req.userId+' and dep_id in ('+depIds+')', null, function() {
    dao.execute('insert into sys_user_subdep(org_id,user_id,dep_id) select '
      +req.session.orgId+','+req.userId+',id from sys_dep where id in ('
      +depIds+')', null, function() {
      var orgDao = new Org(self);
      orgDao.setLastUpdate(req.session.orgId, function(lastUpdate) { 
        req.session.cache.radd("user_dep", {user_id: parseInt(req.userId), 
          dep_id: req.depIdList.toIntArray()}, function(err){
          if(err) {
            self.onLogicError(4, err.message, req, res);
            return;
          }
          self.end(res);
        });
      });
    });
  });
};