var Service = require('Service');
var utils = require('utils');
var UserPost = require('../../dao/user_post');
var util = require('util');

/**
 * 添加职务
 */
var AddPost = function () {
  Service.call(this);
};

util.inherits(AddPost, Service);

module.exports = AddPost;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
AddPost.prototype.process = function (req, res, cb) {
  if (!req.code) {
    this.onLogicError(1, '请提供编码！');
    return;
  }
  if (!req.name) {
    this.onLogicError(2, '请提供名称！');
    return;
  }

  var self = this;
  var dao = new UserPost(this);
  dao.query({
    where: 'name=\'' + req.name + '\' and org_id=' + req.session.orgId,
    fields: 'id'
  }, function (rows) {
    if (rows.length > 0) {
      self.onLogicError(3, '名称已经存在！');
      return;
    }
    var post = {};
    post.org_id = req.session.orgId;
    post.code = req.code;
    post.name = req.name;
    post.creater_id = req.session.userId;
    post.createtime = new Date();
    dao.create(post, function (ret) {
      res.id = ret.insertId;
      self.end(res);
    });
  });
};