var Service = require('Service');
var utils = require('utils');
var util = require('util');
var request = require('request');

// 发送推送消息
var SendMessageWeixin = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
    this.sqlInject.exclude = ["description"];
    this.xssInject.exclude = ["description"];
};

util.inherits(SendMessageWeixin, Service);

module.exports = SendMessageWeixin;
SendMessageWeixin.prototype.process = function (req, res) {
    if (!req.corpid) {
        this.onLogicError(1, '请提供企业ID！');
        return;
    }
    if (!req.corpsecret) {
        this.onLogicError(1, '请提供应用秘钥！');
        return;
    }
    if (!req.agentid) {
        this.onLogicError(1, '请提供应用ID！');
        return;
    }
    if (!req.title) {
        this.onLogicError(1, '请提供标题！');
        return;
    }
    if (!req.description) {
        this.onLogicError(1, '请提供详细描述！');
        return;
    }
    if (!req.url) {
        this.onLogicError(1, '请提供ulr链接！');
        return;
    }
    var self = this;
    if (!server.cache[req.agentid]) {
        self.getToken(req, res);
    } else {
        var wxInfo = server.cache[req.agentid];
        var oldTime = wxInfo.expires_time;
        if (oldTime) {
            var newTime = new Date().getTime();
            //判断上一次获取access_token时间是否超过7000秒，超过重新获取access_token
            if (newTime - oldTime > 7000 * 1000) {
                self.getToken(req, res);
            } else {
                if (wxInfo.access_token) {
                    req.access_token = wxInfo.access_token;
                    self.sendMessage(req, res);
                } else {
                    self.getToken(req, res);
                }
            }
        } else {
            self.getToken(req, res);
        }
    }
}
// 获取应用token
// 每个应用有独立的secret，获取到的access_token只能本应用使用，所以每个应用的access_token应该分开来获取
SendMessageWeixin.prototype.getToken = function (req, res) {
    var self = this;
    // 应用secret编号
    let url = `https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=${req.corpid}&corpsecret=${req.corpsecret}`;
    logger.log(url);
    request(url, { timeout: 3000 }, function (err, response, data) {
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            var obj = {
                access_token: data.access_token,
                expires_time: new Date().getTime()
            }
            server.cache[req.agentid] = obj;
            req.access_token = data.access_token;
            logger.log("获取应用token");
            self.sendMessage(req, res);
        } else {
            res.code = -1;
            res.message = data.errmsg;
            self.end(res);
        }
    })
}
// 发送消息
SendMessageWeixin.prototype.sendMessage = function (req, res) {
    var self = this;
    let url = `https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=${req.access_token}`;
    let message = {
        "touser": "YueMing",
        "msgtype": "textcard",
        "agentid": req.agentid,
        "textcard": {
            "title": req.title,
            "description": req.description,
            "url": req.url,
            "btntxt": "详情"
        },
        "enable_id_trans": 0,
        "enable_duplicate_check": 0,
        "duplicate_check_interval": 1800
    };
    request.post({ url: url, body: JSON.stringify(message) }, function (error, response, body) {
        if (JSON.parse(body).errcode != 0) {
            self.onLogicError(JSON.parse(body).errcode, JSON.parse(body).errmsg);
            return;
        }
        res.msgid = JSON.parse(body).msgid;
        self.end(res);
    });
}
