var Service = require('Service');
var utils = require('utils');
var util = require('util');
var request = require('request');

// 第三方钉钉授权
var SendMessageDing = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
    this.sqlInject.exclude = ["description"];
    this.xssInject.exclude = ["description"];
};

util.inherits(SendMessageDing, Service);

module.exports = SendMessageDing;
SendMessageDing.prototype.process = function (req, res) {
    if (!req.appkey) {
        this.onLogicError(1, '请提供appkey！');
        return;
    }
    if (!req.appsecret) {
        this.onLogicError(1, '请提供appsecret！');
        return;
    }
    var self = this;
    if (!server.cache[req.appkey]) {
        self.getToken(req, res);
    } else {
        var dingInfo = server.cache[req.appkey];
        var oldTime = dingInfo.expires_time;
        if (oldTime) {
            var newTime = new Date().getTime();
            //判断上一次获取access_token时间是否超过7000秒，超过重新获取access_token
            if (newTime - oldTime > 7000 * 1000) {
                self.getToken(req, res);
            } else {
                if (dingInfo.access_token) {
                    req.access_token = dingInfo.access_token;
                    self.sendMessage(req, res);
                } else {
                    self.getToken(req, res);
                }
            }
        } else {
            self.getToken(req, res);
        }
    }
}
// 获取应用token
SendMessageDing.prototype.getToken = function (req, res) {
    var self = this;
    let appkey = req.appkey; // 应用appkey
    let appsecret = req.appsecret; // 应用appsecret
    let url = `https://oapi.dingtalk.com/gettoken?appkey=${appkey}&appsecret=${appsecret}`;
    request(url, { timeout: 3000 }, function (err, response, data) {
        console.log("data", data)
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            var obj = {
                access_token: data.access_token,
                expires_time: new Date().getTime()
            }
            server.cache[req.appkey] = obj;
            req.access_token = data.access_token;
            logger.log("获取应用token", req.access_token);
            self.sendMessage(req, res);
        } else {
            res.code = -1;
            res.message = data.sub_msg;
            self.end(res);
        }
    })
}
// 发送消息
SendMessageDing.prototype.sendMessage = function (req, res) {
    var self = this;
    let url = `https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2?access_token=${req.access_token}`;
    let message = {
        "agent_id": req.agentid,
        "userid_list": "0657124511761787",
        "msg": {
            "msgtype": "action_card",
            "action_card": {
                "title": req.title,
                "markdown": "**" + req.title + "**  \n  <br> 管理员向您转交了一份工作，请您尽快办理！  \n  【工作日报】管理员",
                "single_title": "查看详情",
                "single_url": req.url
            }
        }
    };
    request.post({ url: url, body: JSON.stringify(message) }, function (error, response, body) {
        logger.log(body);
        if (JSON.parse(body).errcode != 0) {
            self.onLogicError(JSON.parse(body).errcode, JSON.parse(body).errmsg);
            return;
        }
        res.msgid = JSON.parse(body).task_id;
        self.end(res);
    });
}
