var Service = require('Service');
var utils = require('utils');
var util = require('util');
var request = require('request');

// 第三方钉钉授权
var getOauth2Dingtalk = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(getOauth2Dingtalk, Service);

module.exports = getOauth2Dingtalk;
getOauth2Dingtalk.prototype.process = function (req, res) {
    if (!req.appkey) {
        this.onLogicError(1, '请提供appkey！');
        return;
    }
    if (!req.appsecret) {
        this.onLogicError(1, '请提供appsecret！');
        return;
    }
    var self = this;
    if (!server.cache[req.appkey]) {
        self.getToken(req, res);
    } else {
        var dingInfo = server.cache[req.appkey];
        var oldTime = dingInfo.expires_time;
        if (oldTime) {
            var newTime = new Date().getTime();
            //判断上一次获取access_token时间是否超过7000秒，超过重新获取access_token
            if (newTime - oldTime > 7000*1000) {
                self.getToken(req, res);
            } else {
                if (dingInfo.access_token) {
                    req.access_token = dingInfo.access_token;
                    self.getUserId(req, res);
                } else {
                    self.getToken(req, res);
                }
            }
        } else {
            self.getToken(req, res);
        } 
    }
}
// 获取应用token
getOauth2Dingtalk.prototype.getToken = function (req, res) {
    var self = this;
    let appkey = req.appkey; // 应用appkey
    let appsecret = req.appsecret; // 应用appsecret
    let url = `https://oapi.dingtalk.com/gettoken?appkey=${appkey}&appsecret=${appsecret}`;
    request(url, { timeout: 3000 }, function (err, response, data) {
        console.log("data", data)
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            var obj = {
                access_token: data.access_token,
                expires_time: new Date().getTime()
            }
            server.cache[req.appkey] = obj;
            req.access_token = data.access_token;
            logger.log("获取应用token", req.access_token);
            self.getUserId(req, res);
        } else {
            res.code = -1;
            res.message = data.sub_msg;
            self.end(res);
        }
    })
}
// 通过token和code获取userid
getOauth2Dingtalk.prototype.getUserId = function (req, res) {
    var self = this;
    let url = `https://oapi.dingtalk.com/topapi/v2/user/getuserinfo?access_token=${req.access_token}&code=${req.code}`;
    request(url, { timeout: 3000 }, function (err, response, data) {
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            req.userid = data.result.userid;
            logger.log("通过token和code获取userid", req.userid);
            self.getUserInfo(req, res);
        } else {
            res.code = -1;
            res.message = data.sub_msg;
            self.end(res);
        }
    })
}
// 通过access_token和userid获取用户详细信息
getOauth2Dingtalk.prototype.getUserInfo = function (req, res) {
    var self = this;
    let url = `https://oapi.dingtalk.com/topapi/v2/user/get?access_token=${req.access_token}&language=zh_CN&userid=${req.userid}`;
    request(url, { timeout: 3000 }, function (err, response, data) {
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            res.userid = req.userid;
            res.userinfo = data.result;
            self.end(res);
        } else {
            res.code = -1;
            res.message = data.sub_msg;
            self.end(res);
        }
    })
}
