var Service = require('Service');
var util = require('util');
var UserDao = require('../../dao/user');

/**
 * 获得默认UI风格
 */
var SetUserTheme = function() { 
  Service.call(this);
};

util.inherits(SetUserTheme, Service);

module.exports = SetUserTheme;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SetUserTheme.prototype.process =  function(req, res) { 
	if(!req.id) {
    this.onLogicError(1, '请提供风格编号！');
    return;
  }
  var isExists = false;
  for(var i=0;i<server.config.Themes.length;i++) {
    var theme = server.config.Themes[i];
    if(theme.id==req.id) {
      isExists = true;
      break;
    }
  }
  if(!isExists) {
    this.onLogicError(2, '请提供正确的风格编号！');
    return;
  }

  var self = this;
  var userDao = new UserDao(this);
  userDao.update({theme_id:req.id},{where:'org_id='+req.session.orgId
    +' and id='+req.session.userId}, function() {
    req.session.cache.set('user', req.session.userId, {theme_id:req.id}, true, function(err){
      if(err) {
        self.onLogicError(3, err.message);
        return;
      }
      self.end(res);
    });
  });
};