var Service = require('Service');
var util = require('util');

/**
 * 获得默认UI风格
 */
var GetDefaultTheme = function () {
	Service.call(this);
	this.checkLogin = false;
};

util.inherits(GetDefaultTheme, Service);

module.exports = GetDefaultTheme;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetDefaultTheme.prototype.process = function (req, res) {
	var defaultTheme = server.config.Themes[0];
	if (server.config.DefaultTheme != defaultTheme.id) {
		for (var i = 1; i < server.config.Themes.length; i++) {
			var theme = server.config.Themes[i];
			if (theme.id == server.config.DefaultTheme) {
				defaultTheme = theme;
				break;
			}
		}
	}
	res.defaultTheme = defaultTheme;
	this.end(res);
};