var Service = require('Service');
var Dao = require('Dao');
var util = require('util');
var crypto = require('crypto');

/**
 * 判断签章密码
 */
var VerifyPwd = function () {
  Service.call(this);
  this.checkAuthority = false;
  this._dao = new Dao(this);
};

util.inherits(VerifyPwd, Service);

module.exports = VerifyPwd;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
VerifyPwd.prototype.process = function (req, res) {
  if (!req.signPwd) {
    this.onLogicError(2, '签章密码不能为空！');
    return;
  }

  if (req.signPwd.length < 4) {
    this.onLogicError(3, '签章密码长度不能小于4位！');
    return;
  }

  if (req.signPwd.length > 20) {
    this.onLogicError(4, '签章密码长度不能超过20！');
    return;
  }

  var reg = /\s|'/i;
  if (reg.test(req.signPwd)) {
    this.onLogicError(5, '签章密码不能包含单引号和空格！');
    return;
  }

  var self = this;
  let params = [];
  params.push(req.session.userId);
  self._dao.execute(
    "select user_id,user_name,dep_id,dep_name,post_id,post_name,sign_type,sign_password,sign_code from vsys_user_sign where user_id=? order by sign_id desc", params,
    function (rows) {
      if (rows.length == 0) {
        self.onLogicError(4, '签章信息有误！');
        return;
      }

      //加密
      var md52 = crypto.createHash('md5');
      md52.update(req.signPwd);
      req.signPwd = md52.digest('hex');

      var sign = rows[0];
      if (sign.sign_password != (req.signPwd + '')) {
        self.onLogicError(5, '签章密码不正确！');
        return;
      }

      res.curSign = sign;
      self.end(res);
    })
};