var Service = require('Service');
var util = require('util');
var Dao = require('Dao');

/**
 * 获得签章信息
 */
var GetInfo = function () {
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(GetInfo, Service);

module.exports = GetInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetInfo.prototype.process = function (req, res) {
  var self = this;

  let params = [];
  params.push(req.session.userId);
  self._dao.execute(
    "select user_id,user_name,dep_id,dep_name,post_id,post_name,sign_type,sign_password,sign_code from vsys_user_sign where user_id=? order by sign_id desc", params,
    function (rows) {
      if (rows.length > 0) res.curSign = rows[0];
      self.end(res);
    });
};