var util = require('util');
var Service = require('Service');
var utils = require('utils');

/**
 * 设置Web服务器信息
 */
var SetWebServerInfo = function() { 
  Service.call(this);
};

util.inherits(SetWebServerInfo, Service);

module.exports = SetWebServerInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SetWebServerInfo.prototype.process =  function(req, res) { 
  if(!req.Port) {
    this.onLogicError(1, '请提供服务器端口！', req, res);
    return;
  }
  if(!utils.isInt(req.Port) || parseInt(req.Port)<=0 || parseInt(req.Port)>65535) {
    this.onLogicError(2, '请提供正确的服务器端口！', req, res);
    return;
  }
  if(!req.ResponseTimeout) {
    this.onLogicError(3, '请提供响应超时时间！', req, res);
    return;
  }
  if(!utils.isInt(req.ResponseTimeout) || parseInt(req.ResponseTimeout)<=0) {
    this.onLogicError(4, '请提供正确的响应超时时间！', req, res);
    return;
  }
  if(!req.SessionPollInterval) {
    this.onLogicError(5, '请提供会话检查轮询间隔！', req, res);
    return;
  }
  if(!utils.isInt(req.SessionPollInterval) || parseInt(req.SessionPollInterval)<=0) {
    this.onLogicError(6, '请提供正确的会话检查轮询间隔！', req, res);
    return;
  }
  if(!req.SessionTimeout) {
    this.onLogicError(7, '请提供会话超时时间！', req, res);
    return;
  }
  if(!utils.isInt(req.SessionTimeout) || parseInt(req.SessionTimeout)<=0) {
    this.onLogicError(8, '请提供正确的会话超时时间！', req, res);
    return;
  }

  server.config.Port = req.Port;
  server.config.UseHttps = false;
  if(req.UseHttps) server.config.UseHttps = true;
  server.config.ResponseTimeout = req.ResponseTimeout;
  if(!server.config.SessionManager) server.config.SessionManager = {};
  server.config.SessionManager.pollInterval = req.SessionPollInterval;
  server.config.SessionManager.sessionTimeout = req.SessionTimeout;
  server.sessionManager.setConfig(server.config.SessionManager);
  
  utils.saveJSONToFile(utils.getPath('/config/'+server.id+'.json'), server.config);

  this.end(res);
};
