var Service = require('Service');
var utils = require('utils');
var util = require('util');
var OrgDao = require('../../dao/org')

/**
 * 设置任讯相关设置信息
 */
var SetTaskMsgInfo = function() { 
  Service.call(this);
};

util.inherits(SetTaskMsgInfo, Service);

module.exports = SetTaskMsgInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SetTaskMsgInfo.prototype.process =  function(req, res) {
  var org = {
    disable_msg_center: 0,
    disable_address_book : 0,
    disable_chat : 0,
    only_app_center : 0,
    disable_app_center : 0
  };
  if(parseInt(req.disable_msg_center)==1) org.disable_msg_center = 1;
  if(parseInt(req.disable_address_book)==1) org.disable_address_book = 1;
  if(parseInt(req.disable_chat)==1) org.disable_chat = 1;
  if(parseInt(req.disable_app_center)==1) org.disable_app_center = 1;
  if(parseInt(req.only_app_center)==1) org.only_app_center = 1;
  org.app_center_title = "工作台";
  if(req.app_center_title) org.app_center_title = req.app_center_title;
  org.app_center_url = "/app/sys/mobile/home_taskmsg.html";
  if(req.app_center_url) org.app_center_url = req.app_center_url;
  
  var self = this;
  var orgDao = new OrgDao(this);
  orgDao.update(org, { where: 'id=' + req.session.orgId }, function () {
    req.session.cache.setCurOrg(org, function () {
      utils.saveJSONToFile(utils.getPath('/config/' + server.id + '.json'), server.config);
      self.end(res);
    });
  })
};