var Service = require('Service');
var util = require('util');
var utils = require('utils');

/**
 * 设置系统菜单栏背景色
 */
var SetDBInfo = function () {
    Service.call(this);
};

util.inherits(SetDBInfo, Service);

module.exports = SetDBInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SetDBInfo.prototype.process = function (req, res) {
  if (!server.config.ThemeSetting) {
        server.config.ThemeSetting = {
            SysThemeColor: [],
            SysMenuBgColor: []
        }
    }

    if (!req.theme_color) {
        this.onLogicError(1, '系统菜单栏背景色不能为空！', req, res);
        return;
    }
    let themeColorList = server.config.ThemeSetting.SysMenuBgColor;
    let exists = themeColorList.includes(req.theme_color);
    if (exists) {
        this.onLogicError(1, '当前系统菜单栏背景色已存在！', req, res);
        return;
    }

    themeColorList.push(req.theme_color);
    server.config.ThemeSetting.SysMenuBgColor = themeColorList;
    utils.saveJSONToFile(utils.getPath('/config/' + server.id + '.json'), server.config);

    this.end(res);
};
