var Service = require('Service');
var utils = require('utils');
var util = require('util');
var OrgDao = require('../../dao/org')

/**
 * 设置任讯相关设置信息
 */
var SetTaskMsgInfo = function() { 
  Service.call(this);
};

util.inherits(SetTaskMsgInfo, Service);

module.exports = SetTaskMsgInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SetTaskMsgInfo.prototype.process =  function(req, res) {
  var self = this;
  req.session.cache.getCurOrg(function(orgNew) {
      if(!server.config.MessagePush) {
          server.config.MessagePush = {};
      }
      let pushServerHost = "push.taskmsg.com";
      let pushServerPort = 7103;
      if(req.pushServerHost) pushServerHost = req.pushServerHost;
      if(req.pushServerPort) pushServerPort = req.pushServerPort;
      server.config.MessagePush.PushServer = {
          host: pushServerHost,
          port: pushServerPort,
          loginCode: orgNew.code,
          loginKey: orgNew.auth_key
      };
      server.config.MessagePush.msgIdFilePath = "/cache/msgId.json";
      server.config.MessagePush.enableAndPush = true;

      utils.saveJSONToFile(utils.getPath('/config/' + server.id + '.json'), server.config);

      if( utils.isNull(req.sysServerHost) && utils.isNull(req.tcpFileServerHost)) {
        self.end(res);
        return;
      }

      var serverConfig = {
        "message": {
          "mode": "platform",
          "protocol": "tcp",
          "host": "push.taskmsg.com",
          "port": "7103"
        },
        "webSocket": {
            "mode": "disable",
            "protocol": "",
            "host": "",
            "port": ""
        }
      };
      if(req.sysServerHost) {
        serverConfig.sys = {
          "mode": "private",
          "protocol": "http",
          "host": req.sysServerHost,
          "port": parseInt(req.sysServerPort)
        };
        if(server.config.UseHttps) serverConfig.sys.protocol = "https";
        serverConfig.web = {};
        for(var p in serverConfig.sys) {
          serverConfig.web[p] = serverConfig.sys[p];
        }
      }
      if(req.tcpFileServerHost) {
        serverConfig.tcp = {
          "mode": "private",
          "protocol": "tcp",
          "host": req.tcpFileServerHost,
          "port": parseInt(req.tcpFileServerPort)
        };
      }
      if(req.pushServerHost && req.pushServerHost!="push.taskmsg.com") {
        serverConfig.message = {
          "mode": "private",
          "protocol": "tcp",
          "host": req.pushServerHost,
          "port": parseInt(req.pushServerPort)
        };
      }

      var ts = (new Date()).getTime();
      var ivData = [orgNew.code, orgNew.auth_key, ts];
      var iv = utils.md5(JSON.stringify(ivData)).substr(0, 16);
      ivData.push(iv);
      var key = utils.md5(JSON.stringify(ivData));
      var data = utils.encryptAES(JSON.stringify(ivData), key, iv);

      self.sendHttpRequest({
          "urlPath": "http://om.taskmsg.com/Service",
          "method": "post",
          "headers": {
              "Content-Type": "application/x-www-form-urlencoded"
          },
          "postdata": {
              "service": "om/service/organize/setServerConfig",
              "orgCode": orgNew.code,
              "ts": ts,
              "data": data,
              "serverConfig": serverConfig
          }
      },
      function (reqHttp, resHttp, errHttp, retHttp) {
          if (errHttp) {
              self.onLogicError(1, '设置外网设置信息失败，错误描述：' + errHttp.message);
              return;
          }
          if(!retHttp || (retHttp+"").indexOf("{")!=0) {
              self.onLogicError(1, '设置外网设置信息失败，平台返回信息格式有误！');
              return;
          }
          let retObj = JSON.parse(retHttp);
          if(retObj.code!=0) {
              self.onLogicError(1, '设置外网设置信息失败，错误描述：' + retObj.message);
              return;
          }
          self.end(res);
      });
  });
};