var Service = require('Service');
var util = require('util');
var utils = require('utils');

var SetFrameworkSetting = function () {
    Service.call(this);
};

util.inherits(SetFrameworkSetting, Service);

module.exports = SetFrameworkSetting;

/**
 * 设置框架信息
 * @param  {Object} req 服务请求对象
 * @param  {Object} req.sysThemeColor 系统主题色
 * @param  {Object} req.sysMenuBgColor 系统菜单栏背景色
 * @param  {Object} res 服务响应对象
 */
SetFrameworkSetting.prototype.process = function (req, res) {
    const { sysThemeColor, sysMenuBgColor } = req;

    server.config.FrameworkSetting = {
        SysThemeColor: '',
        SysMenuBgColor: ''
    }

    if (sysThemeColor) server.config.FrameworkSetting.SysThemeColor = sysThemeColor;
    if (sysMenuBgColor) server.config.FrameworkSetting.SysMenuBgColor = sysMenuBgColor;

    utils.saveJSONToFile(utils.getPath(`/config/${server.id}.json`), server.config);

    this.end(res);
};
