var Service = require('Service');
var util = require('util');
var utils = require('utils');

/**
 * 设置附件信息
 */
var SetAttachInfo = function() { 
  Service.call(this);
};

util.inherits(SetAttachInfo, Service);

module.exports = SetAttachInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SetAttachInfo.prototype.process =  function(req, res) { 
	if(!req.savePath) {
    this.onLogicError(1, '请提供保存路径！', req, res);
    return;
  }
  if(!req.uploadMaxSize) {
    this.onLogicError(2, '请提供文件上传最大值！', req, res);
    return;
  }
  if(!utils.isInt(req.uploadMaxSize)) {
    this.onLogicError(3, '请提供正确的文件大小！', req, res);
    return;
  }
  if(!req.cacheSaveDays) {
    this.onLogicError(4, '请提供缓存保留时长！', req, res);
    return;
  }
  if(!utils.isInt(req.cacheSaveDays) || parseInt(req.cacheSaveDays)<=0) {
    this.onLogicError(5, '请提供正确的缓存保留时长！', req, res);
    return;
  }
  /*if(!req.clearAttachTime) {
    this.onLogicError(6, '请提供每天清除缓存时间！', req, res);
    return;
  }
  if(req.clearAttachTime.length!=5 || req.clearAttachTime.indexOf(':')!=2 
    || req.clearAttachTime.split(':').length!=2) {
    this.onLogicError(7, '请提供正确的清除缓存时间！', req, res);
    return;
  }*/
  server.config.Attach.savePath = req.savePath;
  server.config.Attach.uploadMaxSize = req.uploadMaxSize*1024*1024;
  server.config.Attach.cacheSaveDays = req.cacheSaveDays;
  
  utils.saveJSONToFile(utils.getPath('/config/'+server.id+'.json'), server.config);

  this.end(res);
};
