var Service = require('Service');
var util = require('util');

/**
 * 获得Web服务器信息
 */
var GetWebServerInfo = function() { 
  Service.call(this);
};

util.inherits(GetWebServerInfo, Service);

module.exports = GetWebServerInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetWebServerInfo.prototype.process =  function(req, res) { 
  res.data = {
    Port : server.config.Port,
    UseHttps : server.config.UseHttps,
    ResponseTimeout : server.config.ResponseTimeout
  };

  if(!server.config.SessionManager) {
    res.data.SessionPollInterval = server.sessionManager.pollInterval;
    res.data.SessionTimeout = server.sessionManager.sessionTimeout;
  } else {
    res.data.SessionPollInterval = server.config.SessionManager.pollInterval;
    res.data.SessionTimeout = server.config.SessionManager.sessionTimeout;
  }
  this.end(res);
};
