var Service = require('Service');
var utils = require('utils');
var util = require('util');

/**
 * 获得任讯相关设置信息
 */
var Get = function() { 
  Service.call(this);
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process =  function(req, res) {
  var self = this;
  req.session.cache.getCurOrg(function(org) {
    res.data = {
        disable_msg_center : org.disable_msg_center,
        disable_address_book : org.disable_address_book,
        disable_chat : org.disable_chat,
        only_app_center : org.only_app_center,
        disable_app_center : org.disable_app_center,
        app_center_title : org.app_center_title,
        app_center_url : org.app_center_url
    };
    if(!res.data.app_center_title) res.data.app_center_title = "工作台";
    if(!res.data.app_center_url) res.data.app_center_url = "/app/sys/mobile/home_taskmsg.html";
    self.end(res);
  });
};