var Service = require('Service');
var utils = require('utils');
var util = require('util');
var OrgDao = require('../../dao/org');

/**
 * 获得组织信息
 */
var Get = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process =  function(req, res) {
  var self = this;
  let lcInfo = server.lcManager.getLcInfo();
  req.session.cache.getCurOrg(function(org) {
    req.session.cache.len('user', null, function(err, count) {
      res.data = {
        serverId: server.id,
        serverName: server.name,
        serverEdition: server.edition,
        serverVersion: server.version,
        serverPath: server.serverPath,
        serverStartTime: server.startTime,
        orgCode : server.config.OrgCode,
        orgName : org.name,
        authKey: org.auth_key,
        orgCreateTime : org.createtime,
        orgLastUpdate : org.last_update,
        orgUserCountAuth : lcInfo.userCount,
        orgUserCountReal : count,
        orgAuthEndDate : lcInfo.timeLimit
      };
      self.end(res);
    });
  });
};